@extends('layouts.app')
@section('title')
Proposal Create
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h4 class="text-primary mb-0">Create Proposal</h4>
        </div>
        <!-- <div class="col-md-6 text-right">
            <a href="{{ route('bills.index') }}" class="btn btn-primary">Bills</a>
        </div> -->
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="x_panel p-20 rounded">
                <div class="x_content" style="padding:0">
                    <form action="{{ route('bills.store') }}" method="POST" id="billForm" enctype="multipart/form-data">
                        @csrf

                        <div class="row">
                            <div class="col-md-6">
                                <label for="customer_id">Customer* :</label>
                                <select id="customer_id" name="customer_id" class="form-control select2" required>
                                    <option value="">--Select Customer--</option>
                                    @foreach ($customers as $row)
                                    <option value="{{$row->autoAcNo}}"
                                        data-extra="{{$row->bin_no}}">{{$row->customer_name}}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label for="particular">Particulars :</label>
                                <input type="text" id="particulars" class="form-control" name="particulars" />
                            </div>
                        </div>

                        <div class="row">
                            <div id="currency-container" class="col-md-6">
                                <label for="currency">Currency* :</label>
                                <select id="currency" name="currency" class="form-control select2" required>
                                    <option value="BDT" selected>BDT</option>
                                    <option value="USD">USD</option>
                                    <option value="Dirham">Dirham</option>
                                    <option value="CNY">CNY</option>
                                </select>
                            </div>

                            <div class="col-md-6">
                                <label for="currency_rate">Currency Rate* :</label>
                                <input type="number" id="currency_rate" class="form-control" name="currency_rate" min="1" required/>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <label for="qty">Bill Qty* :</label>
                                <input type="number" id="qty" class="form-control" name="qty" min="1" required />
                            </div>
                            <div class="col-md-6">
                                <label for="unit_price_vat">Unit Price* :</label>
                                <input type="number" id="unit_price_vat" class="form-control" min="1" step="0.01" name="unit_price_vat"
                                    required />
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <label for="total_amount">Total Amount* :</label>
                                <input type="number" id="total_amount" value="0.00" class="form-control"
                                    name="total_amount" readonly />
                            </div>
                            <div class="col-md-6">
                                <label for="bin_number">Bin Number :</label>
                                <input type="number" id="bin_number" class="form-control" name="bin_number" readonly/>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <label for="ref_no">Bill Ref. No :</label>
                                <input type="text" id="ref_no" class="form-control" name="ref_no" />
                            </div>
                            <div class="col-md-6">
                                <label for="ref_date">Bill Ref. Date :</label>
                                <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                    <input type="text" class="form-control has-feedback-left custom-datepicker"
                                        name="ref_date" id="ref_date" placeholder="dd/mm/yyyy" autocomplete="off">
                                    <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true"></span>
                                    <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <label for="installation_date">Date of Installation :</label>
                                <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                    <input type="text" class="form-control has-feedback-left custom-datepicker"
                                        name="installation_date" id="installation_date" placeholder="dd/mm/yyyy"
                                        autocomplete="off">
                                    <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true"></span>
                                    <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <label for="activation_date">Activation Date :</label>
                                <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                    <input type="text" class="form-control has-feedback-left custom-datepicker"
                                        name="activation_date" id="activation_date" placeholder="dd/mm/yyyy"
                                        autocomplete="off">
                                    <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true"></span>
                                    <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <label for="start_date">Bill Start Date* :</label>
                                <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                    <input type="text" class="form-control has-feedback-left custom-datepicker"
                                        name="start_date" id="start_date" placeholder="dd/mm/yyyy" autocomplete="off" required>
                                    <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true"></span>
                                    <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <label for="end_date">Bill End Date* :</label>
                                <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                    <input type="text" class="form-control has-feedback-left custom-datepicker"
                                        name="end_date" id="end_date" placeholder="dd/mm/yyyy" autocomplete="off" required>
                                    <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true"></span>
                                    <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <label for="department_id">Department* :</label>
                                <select id="department_id" name="department_id" class="form-control select2" required>
                                    <option value="">--Select Department--</option>
                                    @foreach ($departments as $row)
                                    @if($row['divCode']!='000')
                                    <option value="{{$row['divCode']}}">{{$row['divName']}}</option>
                                    @endif
                                    @endforeach
                                </select>
                                <input type="hidden" id="billDivName" name="billDivName">
                            </div>
                            <div class="col-md-6">
                                <label for="bill_type">Bill Type* :</label>
                                <select id="bill_type" name="bill_type" class="form-control select2" required>
                                    <option value="">--Select Bill Type--</option>
                                    <option value="One Time">One Time</option>
                                    <option value="Monthly">Monthly</option>
                                    <option value="Quarterly">Quarterly</option>
                                    <option value="Half Yearly">Half Yearly</option>
                                    <option value="Yearly">Yearly</option>
                                </select>
                            </div>
                            <!-- <div class="col-md-6">
                                <label for="bill_group">Bill Group :</label>
                                <input type="text" id="bill_group" class="form-control" name="bill_group" />
                            </div> -->
                        </div>
                        <div class="row">

                            <!-- <div class="col-md-6">
                                <label for="payment_type">Payment Type* :</label>
                                <select id="payment_type" name="payment_type" class="form-control select2" required>
                                    <option value="">--Select Payment Type--</option>
                                    <option value="Prepaid">Prepaid</option>
                                    <option value="Postpaid">Postpaid</option>
                                </select>
                            </div> -->

                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <label for="vat_status">VAT Status :</label>
                                <select id="vat_status" name="vat_status" class="form-control select2">
                                    <option value="1">Yes</option>
                                    <option value="0">No</option>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label for="vat_percent">VAT (%) :</label>
                                <!-- <input type="number" id="vat_percent" class="form-control" name="vat_percent" /> -->
                                <select id="vat_percent" name="vat_percent" class="form-control select2" >
                                    <option value="">--Select VAT--</option>
                                    @foreach ($vatsetup as $vatsetups)
                                        <option value="{{ $vatsetups->vat }}">{{ $vatsetups->vat }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="row">
                            <!-- <div class="col-md-6">
                                <label for="yearly_increase_percent">Yearly Increase (%) :</label>
                                <input type="number" id="yearly_increase_percent" class="form-control"
                                    name="yearly_increase_percent" />
                            </div> -->
                            <!-- <div class="col-md-12">
                                <label for="increase_start_date">Increase Start Date :</label>
                                <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                    <input type="text" class="form-control has-feedback-left custom-datepicker"
                                        name="increase_start_date" id="increase_start_date" placeholder="dd/mm/yyyy"
                                        autocomplete="off">
                                    <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true"></span>
                                    <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                </div>
                            </div> -->
                        </div>
                        <div class="row">
                            <!-- <div class="col-md-6">
                                <label for="order_sl_no">Bill Order Sl. No :</label>
                                <input type="number" id="order_sl_no" class="form-control" name="order_sl_no" />
                            </div> -->
                            <!-- <div class="col-md-6">
                                <label for="status">Status :</label>
                                <select id="status" name="status" class="form-control select2">
                                    <option value="Active">Active</option>
                                    <option value="Inactive">Inactive</option>
                                </select>
                            </div> -->
                        </div>


                        <div class="row">
                            <div class="form-group col-md-4">
                                <label for="work_order">Work order / PO* :</label>
                                <input type="file" id="work_order" name="work_order" class="form-control" accept=".jpg, .jpeg, .png, .pdf" required >
                                <span style="color: red; ">(jpg, .jpeg, .png, .pdf)</span>
                            </div>

                            <div class="form-group col-md-4">
                                <label for="installation_uat">Installation / UAT* :</label>
                                <input type="file" id="installation_uat" name="installation_uat" class="form-control" accept=".jpg, .jpeg, .png, .pdf" required >
                                <span style="color: red; ">(jpg, .jpeg, .png, .pdf)</span>
                            </div>

                            <div class="form-group col-md-4">
                                <label for="delivery_challan">Delivery challan :</label>
                                <input type="file" id="delivery_challan" name="delivery_challan" class="form-control" accept=".jpg, .jpeg, .png, .pdf" >
                                <span style="color: red; ">(jpg, .jpeg, .png, .pdf)</span>
                            </div>
                        </div>




                        <div class="row">
                            <div class="col-md-12">
                                <br />
                                <a href="{{ route('bills.create') }}" class="btn btn-info">Cancel</a>
                                <button type="submit" class="btn btn-primary">Submit</button>
                            </div>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
    <style>
        form label {
            margin-bottom: 2px;
            margin-top: 8px;
        }
    </style>
@endsection


@section('script')

    <script>

        $('#customer_id').change(function(){
            var selOption = $(this).children('option:selected');
            var binNo = selOption.data('extra');
            $('#bin_number').val(binNo);
        });

        $('#department_id').change(function(){
            var selOption = $(this).children('option:selected');
            var selText = selOption.text();
            $('#billDivName').val(selText);
        });

        $(document).ready(function() {
            function calculateTotal() {
                var qty = parseFloat($('#qty').val()) || 0;
                var unitPrice = parseFloat($('#unit_price_vat').val()) || 0;
                var total = qty * unitPrice;
                $('#total_amount').val(total.toFixed(2));
            }

            $('#qty, #unit_price_vat').on('input', calculateTotal);
        });


    </script>

<script>
        $(document).ready(function() {
            function updateCurrencyRateField() {
                var selectedCurrency = $('#currency').val();
                if (selectedCurrency === 'BDT') {
                    $('#currency_rate').val(1).prop('readonly', true).show();
                } else {
                    $('#currency_rate').val('').prop('readonly', false).show();
                }
            }
            // Initial update based on default selected currency
            updateCurrencyRateField();

            // Update field on currency change
            $('#currency').change(function() {
                updateCurrencyRateField();
            });
        });
</script>


<script>
    $(document).ready(function () {
        const startDateInput = $('#start_date');
        const endDateInput = $('#end_date');

        startDateInput.on('change', function () {
            const startDate = startDateInput.val();
            if (startDate) {
                endDateInput.attr('min', startDate);
            }
        });

        endDateInput.on('change', function () {
            const startDate = new Date(startDateInput.val().split('/').reverse().join('-'));
            const endDate = new Date(endDateInput.val().split('/').reverse().join('-'));

            if (endDate < startDate) {
                show_toastr('error', 'End Date must be greater than or equal to Start Date');
                endDateInput.val('');
            }
        });
    });
</script>



<script>
    $(document).ready(function () {
        const $vatStatus = $('#vat_status');
        const $vatPercent = $('#vat_percent');
        const $vatPercentError = $('#vat_percent_error');
        const originalOptions = $vatPercent.html(); // Save original options

        function updateVatPercent() {
            if ($vatStatus.val() === '1') { // Yes selected
                $vatPercent.html(originalOptions); // Show all options
                $vatPercent.prop('disabled', false); // Enable the field
                $vatPercent.prop('required', true); // Make it required
            } else { // No selected
                $vatPercent.html('<option value="">--Select VAT--</option>'); // Show only default option
                $vatPercent.prop('disabled', true); // Disable the field
                $vatPercent.prop('required', false); // Remove required
                $vatPercentError.hide(); // Hide any existing error message
            }
        }

        function validateVatPercent() {
            if ($vatStatus.val() === '1' && !$vatPercent.val()) { // If Yes and no value selected
                $vatPercentError.show(); // Show error message
                return false; // Prevent form submission or further actions
            } else {
                $vatPercentError.hide(); // Hide error message
                return true; // Allow form submission or further actions
            }
        }

        $vatStatus.change(function () {
            updateVatPercent();
            validateVatPercent(); // Validate on status change
        });

        $vatPercent.change(function () {
            validateVatPercent(); // Validate on VAT% change
        });

        // Initialize on page load
        updateVatPercent();
    });
</script>


@endsection
